# -*- coding: utf-8 -*-
from setuptools import setup
from django_aws import __version__


DESCRIPTION = "Django AWS backends"
LONG_DESCRIPTION = open('README.md').read()

CLASSIFIERS = [
    'Development Status :: 4 - Beta',
    'Intended Audience :: Developers',
    'License :: OSI Approved :: MIT License',
    'Operating System :: OS Independent',
    'Programming Language :: Python',
    'Programming Language :: Python :: 2.6',
    'Programming Language :: Python :: 2.7',
    'Programming Language :: Python :: 3',
    'Programming Language :: Python :: 3.2',
    'Programming Language :: Python :: 3.3',
    'Programming Language :: Python :: 3.4',
    'Topic :: Software Development :: Libraries :: Python Modules',
    'Framework :: Django',
]

setup(
    name='django-aws',
    version=str(__version__),
    description=DESCRIPTION,
    long_description=LONG_DESCRIPTION,
    author='Piotr Buliński',
    author_email='piotr@bulinski.pl',
    license='BSD licenses',
    url='https://github.com/piotrbulinski/django_aws',
    platforms = "Posix; MacOS X; Windows",
    packages=[
        'django_aws',
        'django_aws.sessions'
    ],
    include_package_data=True,
    install_requires=[
        'boto',
        'django'
    ],
    test_suite="django_aws",
    tests_require=[
        'django',
    ],
    classifiers=CLASSIFIERS,
)
