from django.db import models
from django.utils.translation import ugettext_lazy as _
from django.core.urlresolvers import reverse


class Contact(models.Model):
    submitted = models.DateTimeField(_('submitted'), auto_now_add=True)
    handled = models.BooleanField(_('handled'), default=False)

    def edit_url(self):
        return reverse('admin:%s_%s_change' % (self._meta.app_label, self._meta.module_name), args=[self.id])

    class Meta:
        abstract = True