from django.http import HttpResponseRedirect
from django.views.generic.edit import CreateView
from django.contrib import messages


class BaseContactFormView(CreateView):
    template_name = 'template_files/contact.html'

    def form_valid(self, form):
        if hasattr(self, 'get_success_message'):
            messages.success(self.request, self.get_success_message())
        return super(BaseContactFormView, self).form_valid(form)

    def get_form_kwargs(self):
        # ContactForm instances require instantiation with an
        # HttpRequest.
        kwargs = super(BaseContactFormView, self).get_form_kwargs()
        kwargs.update({'request': self.request})
        return kwargs