from django.utils.translation import ugettext_lazy as _
from contact.forms import BaseContactFormForm
from models import ContactForm
from crispy_forms.helper import FormHelper
from crispy_forms.layout import Layout, Submit
from crispy_forms.bootstrap import FormActions


class ContactFormForm(BaseContactFormForm):

    class Meta:
        model = ContactForm

    helper = FormHelper()
    helper.label_class = 'col-lg-2'
    helper.field_class = 'col-lg-10'
    helper.form_class = 'form-horizontal'
    helper.layout = Layout(
        'name',
        'email',
        'message',
        FormActions(
            Submit('save_changes', _('Send')+' &#187;'),
        )
    )