from django.utils.translation import ugettext_lazy as _
from contact.forms import BaseContactFormForm
from models import ContactForm
from crispy_forms.helper import FormHelper
from crispy_forms.layout import Layout, Submit
from crispy_forms.bootstrap import FormActions


class ContactFormForm(BaseContactFormForm):
    def clean(self):
        cleaned_data = super(ContactFormForm, self).clean()
        email = cleaned_data.get("email")
        phone_number = cleaned_data.get("phone_number")

        if not (phone_number or email):
            # Only do something if both fields are valid so far.
            raise forms.ValidationError(_('Either a phone number or email is mandatory'))
        return cleaned_data

    class Meta:
        model = ContactForm

    helper = FormHelper()
    helper.label_class = 'col-lg-2'
    helper.field_class = 'col-lg-10'
    helper.form_class = 'form-horizontal'
    helper.layout = Layout(
        'name',
        'email',
        'phone_number',
        'message',
        FormActions(
            Submit('save_changes', _('Send')+' &#187;'),
        )
    )