from django.db import models
from django.utils.translation import ugettext_lazy as _
from contact.models import Contact


class ContactForm(Contact):
    name = models.CharField(_('Name'), max_length=255, blank=True)
    email = models.EmailField(_('email'), blank=True)
    phone_number = models.CharField(_('Phone number'), max_length=255, blank=True)
    message = models.TextField(_('Message'), max_length=5000, blank=True)

    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name = _('contact form')
        verbose_name_plural = _('contact forms')