#!/usr/bin/env python
# django-bitly -  Bit.ly integration for django
# 
# Copyright (C) 2009 Discovery Creative
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
"""Bit.ly integration for django

A Django app that supports automatic generation and tracking of bit.ly hashes for objects on the site. Will automatically track changes to URLs, and, if necessary, maintain redirects for moved objects.
"""

from distutils.core import setup


description, long_description = __doc__.split('\n\n', 1)
VERSION = '0.5'

setup(
    name='django-bitly',
    version=VERSION,
    author='Discovery Creative',
    author_email='webworks_support@discovery.com',
    description=description,
    long_description=long_description,
    license='BSD',
    platforms=['any'],
    url='http://bitbucket.org/discovery/django-bitly/',
    download_url=("http://bitbucket.org/discovery/django-bitly/get/0.5.bz2"),
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        ],
    packages=[
        'django_bitly',
        ],
    provides=['django_bitly'],
    requires=['django (>=1.1)', 'simplejson',],
    )
