'''
Created on 2012-08-24

@author: michael
'''
import os
import re
import math

from celery import task,chord
from celery.signals import task_success
from celery.utils.log import get_task_logger

from django.db.models import Q
from django.core.management import call_command
from django.conf import settings

from .models import WordType,WordToken,Dialog,SegmentType,SegmentToken,Speaker,Category,Underlying
from .helper import fetch_buckeye_resource,fetch_media_resource,loadFile

logger = get_task_logger(__name__)

@task()
def loadSegments():
    logger.info("Loading segments...")
    segs = loadFile(fetch_buckeye_resource("SegmentInfo.txt"))
    ss = []
    for s in segs:
        ss.append(SegmentType(Label=s['Label'],Syllabic=bool(int(s['Syllabic'])),Obstruent=bool(int(s['Obstruent'])),Nasal=bool(int(s['Nasal'])),Vowel=bool(int(s['Vowel']))))
    SegmentType.objects.bulk_create(ss)
    logger.info("Loaded segments!")

@task()
def loadSpeakers():
    logger.info("Loading speakers...")
    speakers = loadFile(fetch_buckeye_resource("SpeakerInfo.txt"))
    ss = []
    for s in speakers:
        ss.append(Speaker(Number=s['Number'],Age=s['Age'],Gender=s['Gender'],NumFormants=s['NFormants'],Ceiling=s['Ceiling']))
    Speaker.objects.bulk_create(ss)
    logger.info("Loaded speakers!")

@task()
def loadCategories():
    logger.info("Loading categories...")
    cats = loadFile(fetch_buckeye_resource("CategoryInfo.txt"))
    cs = []
    for s in cats:
        cs.append(Category(Label=s['Label'],Description=s['Description'],CategoryType=s['Type']))
    Category.objects.bulk_create(cs)
    logger.info("Loaded categories!")


@task()
def load_base():
    job = TaskSet(tasks = [loadSegments.subtask(),
                            loadCategories.subtask(),
                            loadSpeakers.subtask(),])


@task()
def load_dialogs():
    sp = Speaker.objects.all()
    for s in sp:
        s.load_dialogs()

@task()
def doReset(logfilename):
    call_command('reset','buckeyebrowser', interactive=False,verbosity=0)
    res = chord((load_base.s()), load_dialogs.s())()
    res.get()

@task()
def combineResults(allout):
    if not os.isdir(fetch_media_resource("Results/Buckeye")):
        os.mkdir(fetch_media_resource("Results/Buckeye"))
    with open(fetch_media_resource("Results/Buckeye/analysis.txt"),'w') as f:
        f.write("\t".join(allout[0][0].keys()))
        f.write("\n")
        for l in allout:
            for line in l:
                f.write("\t".join(map(str,line.values())))
                f.write("\n")

@task()
def AnalyzeSpeaker(speaker,form):
    return speaker.analyze(form)

@task()
def doBasicAnalysis(form):
    sp = [str(x) for x in Speaker.objects.all() if str(x) != 's35']
    if settings.DEBUG:
        sp = Speaker.objects.filter(Number = 's03')
        out = AnalyzeSpeaker.delay(sp[0],form)
    else:
        res = chord((AnalyzeSpeaker.s(words, s, form) for s in sp), combineResults.s())()

#@task_success.connect(sender=doBasicAnalysis)
#def consolidateResultFiles():
#    outs = os.listdir(fetch_buckeye_resource("Results/Buckeye"))
#    os.remove(fetch_buckeye_resource("Results/Buckeye/analysis.txt"))
#    head = False
#    allout = open(fetch_buckeye_resource("Results/Buckeye/analysis.txt"),'w')
#    for fn in outs:
#        f = open(fetch_buckeye_resource("Results/Buckeye/%s"%fn))
#        ls = f.read().splitlines()
#        if not head:
#            allout.write(ls[0]+"\n")
#        allout.write("\n".join(ls[1:]))
#        f.close()
#    allout.close()
