'''
Created on 2012-07-04

@author: michael
'''
from django import forms
from django.conf import settings

class ResetForm(forms.Form):
    reset = forms.BooleanField(initial=True)


class SynSemForm(forms.Form):
    CHOICES = (('N','Unclassified'),
               ('A','Accepted'),
               ('E','Excluded'))
    Filter = forms.CharField(label='Filter cases by')
    Filter.widget = forms.Select(choices=CHOICES)

class RedoSpecGramForm(forms.Form):
    Ceiling= forms.IntegerField(required=False)
    NFormants = forms.FloatField(required=False,label='Number of formants')
    ManualF1 = forms.FloatField(required=False,label='Manual F1')
    ManualF2 = forms.FloatField(required=False,label='Manual F2')

class AnalysisForm(forms.Form):
    M_CHOICES = (('S','SSANOVA-style'),
                ('M','Midpoint'),
                ('D','Dispersion'))
    if 'celex' in settings.INSTALLED_APPS:
        FREQ_CHOICES = (('N','None'),
                     ('B','Buckeye'),
                  ('C','CELEX'),
                  ('S','SUBTLEX'))
        CAT_CHOICES = (('N','None'),
                     ('B','Buckeye'),
                  ('C','CELEX'))
    else:
        FREQ_CHOICES = (('N','None'),
                     ('B','Buckeye'))
        CAT_CHOICES = (('N','None'),
                     ('B','Buckeye'))
    if 'phonostats' in settings.INSTALLED_APPS:
        PHONO_PROB_CHOICES = (('N','None'),
                        ('VB','Vitevitch & Luce from Buckeye corpus words'),
                        ('VP','Vitevitch & Luce from PhonoStats module'),
                        ('B','BLICK metric from PhonoStats module'))
    else:
        PHONO_PROB_CHOICES = (('N','None'),
                            ('VB','Vitevitch & Luce from Buckeye corpus words'))
    if 'phonostats' in settings.INSTALLED_APPS:
        NEIGH_DEN_CHOICES = (('N','None'),
                        ('B','Neighbourhood based on Buckeye words'),
                        ('PS','Neighbourhood based on PhonoStats module'),
                        ('C','Neighbourhood based on CELEX'))
    else:
        NEIGH_DEN_CHOICES = (('N','None'),
                            ('B','Neighbourhood based on Buckeye words'))
    SEM_PRED_WINDOW = tuple([('A','Auto')]+ [('%d' % x, '%d second' % x) for x in range(1,11)])
    SEM_PRED_STYLE = (('A','Average'),
                        ('S','Sum'),
                        ('W','Weighted'))
    #FETCH_CHOICES = (('PrevSemPred','PrevSemPred'),
    #                'FollSemPred','FollSemPred')
    measure = forms.CharField(label='Measure')
    measure.widget = forms.Select(choices=M_CHOICES)
    DispersionFromAH = forms.BooleanField(initial=False,required=False,label="Dispersion from a speaker's AH tokens")
    placeInDialog = forms.BooleanField(initial=True,required=False,label='Time since beginning of dialog')
    speakingRates = forms.BooleanField(initial=True,required=False,label='Speaking rates')
    contextProbs = forms.BooleanField(initial=True,required=False,label='Contextual probabilities')
    repetitions = forms.BooleanField(initial=True,required=False,label='Repetitions')
    wasRepeated = forms.BooleanField(initial=False,required=False,label='Was repeated')
    wordDuration = forms.BooleanField(initial=True,required=False,label='Word duration')
    segmentalDurations = forms.BooleanField(initial=True,required=False,label='Segmental duration')
    category = forms.CharField(label='Category source')
    category.widget = forms.CheckboxSelectMultiple(choices=CAT_CHOICES)
    frequency = forms.CharField(label='Frequency source')
    frequency.widget = forms.CheckboxSelectMultiple(choices=FREQ_CHOICES)
    nd = forms.CharField(label='Neighbourhood density source')
    nd.widget = forms.CheckboxSelectMultiple(choices=NEIGH_DEN_CHOICES)
    phonotactic = forms.CharField(label='Phonotactic probability source')
    phonotactic.widget = forms.CheckboxSelectMultiple(choices=PHONO_PROB_CHOICES)
    gender = forms.BooleanField(initial=True,required=False,label='Gender')
    age = forms.BooleanField(initial=True,required=False,label='Age')
    globalSpeakingRate = forms.BooleanField(initial=True,required=False,label='Global speaking rate')
    orthoLength = forms.BooleanField(initial=True,required=False,label='Orthographic length')
    phonoLength = forms.BooleanField(initial=True,required=False,label='Phonological length')
    numSylls = forms.BooleanField(initial=True,required=False,label='Number of syllables')
    prev_sem_pred = forms.BooleanField(initial=True,required=False,label='Previous semantic predictability')
    foll_sem_pred = forms.BooleanField(initial=True,required=False,label='Following semantic predictability')
    pause_dist = forms.BooleanField(initial=True,required=False,label='Distance to pauses')
    sem_pred_window = forms.CharField(label='Semantic predictability window')
    sem_pred_window.widget = forms.CheckboxSelectMultiple(choices=SEM_PRED_WINDOW)
    sem_pred_style = forms.CharField(label='Semantic predictability style')
    sem_pred_style.widget = forms.CheckboxSelectMultiple(choices=SEM_PRED_STYLE)

    #force_fetch = forms.CharField(label='Force fetch')
    #force_fetch.widget = forms.CheckboxSelectMultiple(choices=FETCH_CHOICES)

    def get_wanted_fields(self):
        form = self.cleaned_data
        wanted_fields =['Word','Token','Vowel','PrevCons','FollCons','Speaker']
        if form['segmentalDurations']:
            wanted_fields.extend(['VowDur','OtherDur'])
        if form['speakingRates']:
            wanted_fields.extend(['PrevSpeakRate','FollSpeakRate','AvgSpeakRate'])
        if form['contextProbs']:
            wanted_fields.extend(['PrevCondProb','FollCondProb'])
        if form['repetitions']:
            wanted_fields.extend(['Repetitions'])
        if form['wasRepeated']:
            wanted_fields.extend(['wasRepeated','wasRepeatedRecently'])
        if 'B' in form['category']:
            wanted_fields.extend(['BuckeyeCategory'])
        if 'C' in form['category']:
            wanted_fields.extend(['CelexCategory'])

        if form['wordDuration']:
            wanted_fields.extend(['WordDuration','BaselineDur'])

        if 'B' in form['frequency']:
            wanted_fields.extend(['BuckeyeFrequency'])
        if 'C' in form['frequency']:
            wanted_fields.extend(['CelexFrequency'])

        if form['gender']:
            wanted_fields.extend(['SpeakerGender'])
        if form['age']:
            wanted_fields.extend(['SpeakerAge'])

        if form['orthoLength']:
            wanted_fields.extend(['OrthoLength'])
        if form['phonoLength']:
            wanted_fields.extend(['PhonoLength'])
        if 'B' in form['nd']:
            wanted_fields.extend(['BuckeyeNeighDen','BuckeyeFWND'])
        if 'PS' in form['nd']:
            wanted_fields.extend(['PhonoStatsNeighDen'])

        if 'VB' in form['phonotactic']:
            wanted_fields.extend(['BuckeyeSPhoneProb','BuckeyeBiPhoneProb'])
        if 'B' in form['phonotactic']:
            wanted_fields.extend(['PhonoStatsBlickPhono'])
        if 'VP' in form['phonotactic']:
            wanted_fields.extend(['PhonoStatsSPhoneProb','PhonoStatsBiPhoneProb'])
        for w in form['sem_pred_window']:
            for s in form['sem_pred_style']:
                if form['prev_sem_pred']:
                    wanted_fields.extend(['%sWindowPrev%sSemPred' %(w,s)])
                if form['foll_sem_pred']:
                    wanted_fields.extend(['%sWindowFoll%sSemPred' %(w,s)])
        if form['pause_dist']:
            wanted_fields.extend(['DistFollPause','DistPrevPause'])
        if form['placeInDialog']:
            wanted_fields.extend(['placeInDialog'])
        if form['measure'] == 'D':
            if form['DispersionFromAH']:
                wanted_fields += ['AHDispersion']
            else:
                wanted_fields += ['Dispersion']
        wanted_fields += ['F1','F2']
        return wanted_fields

    class Meta:
        fieldsets = ((None,
                      {'fields':('measure')}),
                     ('Lexical type factors',
                      {'fields':('frequency',
                                 'category',
                                 'nd',
                                 'phonotactic',
                                 'orthoLength',
                                 'phonoLength',
                                 'numSylls')}),
                     ('Lexical token factors',
                      {'fields':('wordDuration',
                                 'segmentalDurations')}),
                     ('Contextual factors',
                      {'fields':('speakingRates',
                                 'contextProbs',
                                 'repetitions',
                                 'wasRepeated',
                                 'prev_sem_pred',
                                 'foll_sem_pred',
                                 'pause_dist')}),
                     ('Speaker factors',
                      {'fields':('gender',
                                 'age',
                                 'globalSpeakingRate')}))

