from django.db.models import Sum

from .models import FreqDict,Lemma,WordForm,Orthography,Transcription


def checkDict(freqDict):
    if FreqDict.objects.filter(Name=freqDict).exists():
        return True
    return False

def lookupFreq(word):
    qs = Lemma.objects.filter(wordform_set__Orthographies__Spelling = word).aggregate(total_freq = Sum('Frequency'))
    #qs = Orthography.objects.filter(Spelling=word).aggregate(total_freq = Sum('wordform_set__Lemma__Frequency'))
    return qs['total_freq']

#def lookupStress(word,freqDict):
#    qs = Spelling.objects.filter(Label=word).order_by('-Word__Frequency')
#    return [q.StressPattern for q in qs]

def lookupCat(word):
    qs = Lemma.objects.filter(wordform_set__Orthographies__Spelling = word).order_by('-Frequency')
    #qs = Orthography.objects.filter(Label=word).order_by('-Word__Frequency')
    if len(qs) == 0:
        return 'NA'
    cat = qs[0].Label
    if cat == 'ADV':
        cat = 'R'
    return cat.lower()


