
from celery import task,chord,group,chain
from celery.signals import task_success
from celery.utils.log import get_task_logger

from django.conf import settings

from .models import *
from .managers import BulkManager,chunks

logger = get_task_logger(__name__)

def chunk_dict(d, n):
    allout = []
    temp = {}
    for k in d:
        if len(temp) == n:
            allout.append(temp)
            temp = {}
        temp[k] = d[k]
    allout.append(temp)
    return allout

@task()
def doReset():
    lemmas = loadLemmas()
    lemma_job = group(addLemmas.si(x) for x in chunk_dict(lemmas,10000))
    wfs,spells,trans = loadWF()
    wf_job = group(addWFS.si(x) for x in chunk_dict(wfs,10000))
    spell_job = group(addSpells.si(x) for x in chunks(spells,10000))
    trans_job = group(addTrans.si(x) for x in chunks(trans,10000))
    res = (loadCats.si() |wf_job )()
    res.get()


@task()
def loadCats():
    cats = []
    with open(fetch_celex_resource('Category/cats.txt'),'r') as f:
        head = None
        for line in f:
            l = line.strip().split("\t")
            if head is None:
                head = l
                continue
            cats.append(SyntacticCategory(pk=int(l[0]),Label=l[1],Description=l[2],CategoryType=l[3]))
    SyntacticCategory.objects.bulk_create(cats)

@task()
def addLemmas(lemmas):
    ls = []
    for key in lemmas:
        if int(lemmas[key]['CategoryNum']) > 12:
            continue
        cat = SyntacticCategory.objects.get(pk=int(lemmas[key]['CategoryNum']))
        ls.append(Lemma(pk=int(key),Label=lemmas[key]['Word'],Category=cat,Frequency=int(lemmas[key]['Freq'])))
    Lemma.objects.bulk_create(ls)

def loadLemmas():
    lemmas = loadOrthLemmas()
    #lemmas = loadTransLemmas(lemmas)
    lemmas = addCategories(lemmas)
    return lemmas

def loadWF():
    wfs,spells = loadOrthWF()
    wfs,trans = loadTransWF(wfs)
    spells = [(i+1,v) for i,v in enumerate(spells)]
    trans = [(i+1,v) for i,v in enumerate(trans)]
    return wfs,spells,trans

@task()
def addRelationships(wfs):
    wfs = WordForm.objects.all()
    for w in wfs:
        ss = list(Orthography.objects.filter(Spelling__in = wfs[str(w.pk)]['Spellings']))
        w.Orthographies.add(*ss)
        ss = list(Transcription.objects.filter(Transcription__in = wfs[str(w.pk)]['Transcriptions']))
        w.Transcriptions.add(*ts)

@task()
def addWFS(wfs):
    wfss = []
    for key in wfs:
        lem = Lemma.objects.filter(pk=int(wfs[key]['IdLemma']))
        if len(lem) != 1:
            continue
        wfss.append(WordForm(pk=int(wfs[key]),Lemma = lem[0],Frequency = int(wfs[key]['Freq'])))
    WordForm.objects.bulk_create(wfss)

@task()
def addSpells(spells):
    Orthography.objects.bulk_create([Orthography(pk=s[0],Spelling = s[1]) for s in spells])

@task()
def addTrans(spells):
    Transcription.objects.bulk_create([Transcription(pk=t[0],Transcription = t[1]) for t in trans])


def loadOrthLemmas():
    lemmas = {}
    with open(fetch_celex_resource('Orthography/celex-orthography-lemmas.txt'),'r') as f:
        head = None
        for line in f:
            l = line.strip().split("\\")
            if head is None:
                head = l
                continue
            main = l[:8]
            additional = l[8:]
            spellings = [l[1]]
            nl = {'Word':l[1],'Freq':l[2]}
            if len(additional) != 0:
                additional = chunks(additional,4)
                spellings.extend([re.sub(r'-(?!-)',r'',x[3]) for x in additional])
            nl['Spellings'] = set(spellings)
            lemmas[l[0]] = nl
    return lemmas


def addCategories(lemmas):
    with open(fetch_celex_resource('Category/celex-syntax-lemmas.txt'),'r') as f:
        head = None
        for line in f:
            l = line.strip().split("\\")
            if head is None:
                head = l
                continue
            lemmas[l[0]]['CategoryNum'] = l[3]
    return lemmas

def loadOrthWF():
    ss = []
    wfs = {}
    with open(fetch_celex_resource('Orthography/celex-orthography-wordforms.txt'),'r') as f:
        head = None
        for line in f:
            l = line.strip().split("\\")
            if head is None:
                head = l
                continue
            main = l[:9]
            additional = l[9:]
            spellings = [l[1]]
            nl = {'IdLemma':l[3],'Freq':l[2]}
            if len(additional) != 0:
                additional = chunks(additional,5)
                spellings.extend([x[1] for x in additional])
            nl['Spellings'] = set(spellings)
            ss.extend(spellings)
            wfs[main[0]] = nl
    return wfs,ss

def loadTransWF(wfs):
    ts = []
    with open(fetch_celex_resource('Phonology/celex-phonology-wordforms.txt'),'r') as f:
        head = None
        for line in f:
            l = line.strip().split("\\")
            if head is None:
                head = l
                continue
            main = l[:9]
            additional = l[9:]
            trans = [main[6]]
            if len(additional) != 0:
                additional = chunks(additional,4)
                trans.extend([x[1] for x in additional])
            wfs[main[0]]['Transcriptions'] = set(trans)
            ts.extend(trans)
    return wfs,ts

def loadTransLemmas(lemmas):
    with open(fetch_celex_resource('Phonology/celex-phonology-lemmas.txt'),'r') as f:
        head = None
        for line in f:
            l = line.strip().split("\\")
            if head is None:
                head = l
                continue
            main = l[:8]
            additional = l[8:]
            trans = [main[5]]
            if len(additional) != 0:
                additional = chunks(additional,4)
                trans.extend([x[1] for x in additional])
            lemmas[l[0]]['Transcriptions'] = set(trans)
    return lemmas
