from django.db import models
from .managers import BulkManager,chunks
import re

# Create your models here.
from .helper import fetch_celex_resource


class WordManager(BulkManager):
    tbl_name = 'celex_word'
    cols = ['FreqDict_id','Label','Category_id','Frequency']


class TranscriptionManager(BulkManager):
    tbl_name = 'celex_transcription'
    cols = ['Transcription','Word_id']

class SpellingManager(BulkManager):
    tbl_name = 'celex_spelling'
    cols = ['Label','Word_id']



#class SegmentType(models.Model):
#    Label = models.CharField(max_length=10)
#    Syllabic = models.NullBooleanField()
#    Obstruent = models.NullBooleanField()
#    Nasal = models.NullBooleanField()
#    Vowel = models.NullBooleanField()
#
#    def guessProperties(self):
#        NasalInd = ['n','m']
#        VowelInd = set(['i','u','o','e','a'])
#        ApproxInd = ['r','l','y']
#        for s in self.Label.lower():
#            if s in VowelInd:
#                self.Vowel = True
#                break
#        else:
#            self.Vowel = False
#        self.save()
#
#    def isSyllabic(self):
#        return self.Syllabic
#
#    def isNasal(self):
#        return self.Nasal
#
#    def isObs(self):
#        return self.Obstruent
#
#    def isVowel(self):
#        return self.Vowel
#
#    def __unicode__(self):
#        return u'%s' % (self.Label,)

class SyntacticCategory(models.Model):
    label = models.CharField(max_length=50)
    description = models.CharField(max_length=100,blank=True,null=True)
    categoryType = models.CharField(max_length=100,blank=True,null=True)

    def __unicode__(self):
        return self.label


#class CatRelationship(models.Model):
#    Word = models.ForeignKey('Word')
#    Category = models.ForeignKey(SyntacticCategory)
#    Count = models.BigIntegerField(blank=True,null=True)

#    class Meta:
#        ordering = ['-Count']


class Transcription(models.Model):
    transcription = models.CharField(max_length=250)
    stress_pattern = models.CharField(max_length=100,blank=True,null=True)
    cvskel = models.CharField(max_length=100,blank=True,null=True)

    def __unicode__(self):
        return self.transcription

    def strip_transcription(self):
        return self.transcription.replace('-','').replace("'",'').replace('"','')

    #def getCVStruct(self):
    #    if self.CVSkel is not None:
    #        return self.CVSkel
    #    cvstruct = ''
    #    for s in self.Transcription.all():
    #        if s.isVowel():
    #            cvstruct = cvstruct + 'V'
    #        else:
    #            cvstruct = cvstruct + 'C'
    #    self.CVSkel = cvstruct
    #    self.save()
    #    return cvstruct

class Orthography(models.Model):
    spelling = models.CharField(max_length=250)

    def __unicode__(self):
        return self.spelling

class SpelledAs(models.Model):
    word_form = models.ForeignKey('WordForm')
    orthography = models.ForeignKey(Orthography)
    frequency = models.FloatField(blank=True,null=True)

class PronouncedAs(models.Model):
    word_form = models.ForeignKey('WordForm')
    transcription = models.ForeignKey(Transcription)

class WordForm(models.Model):
    lemma = models.ForeignKey('Lemma')
    orthographies = models.ManyToManyField(Orthography,through = 'SpelledAs')
    transcriptions = models.ManyToManyField(Transcription,through = 'PronouncedAs')
    frequency = models.FloatField(blank=True,null=True)

    def get_transcriptions(self):
        return ".".join(str(t) for t in self.transcriptions.all())

    def get_spellings(self):
        return ", ".join(str(s) for s in self.orthographies.all())

    def __unicode__(self):
        return u'%s' % self.lemma.label

class Lemma(models.Model):
    label = models.CharField(max_length=250)
    category = models.ForeignKey(SyntacticCategory)
    frequency = models.FloatField(blank=True,null=True)

    #objects = WordManager()
    def __unicode__(self):
        return self.label

    def get_transcriptions(self):
        return ".".join(str(t) for wf in WordForm.objects.filter(lemma=self) for t in wf.transcriptions.all())

    def get_spellings(self):
        return ", ".join(str(s) for wf in WordForm.objects.filter(lemma=self) for s in wf.orthographies.all())

    #def getPrimaryCategory(self):
    #    if self.PrimaryCategory is not None:
    #        return self.PrimaryCategory
    #    self.PrimaryCategory = self.catrelationship_set.all()[0].Category.Label
    #    self.save()
    #    return self.PrimaryCategory
