from django.db import models
from .managers import BulkManager,chunks

# Create your models here.
from .helper import fetch_celex_resource




class SyntacticCategory(models.Model):
    label = models.CharField(max_length=50)
    description = models.CharField(max_length=100,blank=True,null=True)
    category_type = models.CharField(max_length=100,blank=True,null=True)

    def __unicode__(self):
        return self.label




class Transcription(models.Model):
    transcription = models.CharField(max_length=250)
    stress_pattern = models.CharField(max_length=100,blank=True,null=True)
    cvskel = models.CharField(max_length=100,blank=True,null=True)

    def __unicode__(self):
        return self.transcription

    def strip_transcription(self):
        return self.transcription.replace('-','').replace("'",'').replace('"','')

    #def getCVStruct(self):
    #    if self.CVSkel is not None:
    #        return self.CVSkel
    #    cvstruct = ''
    #    for s in self.Transcription.all():
    #        if s.isVowel():
    #            cvstruct = cvstruct + 'V'
    #        else:
    #            cvstruct = cvstruct + 'C'
    #    self.CVSkel = cvstruct
    #    self.save()
    #    return cvstruct

class Orthography(models.Model):
    spelling = models.CharField(max_length=250)

    def __unicode__(self):
        return self.spelling

class SpelledAs(models.Model):
    word_form = models.ForeignKey('WordForm')
    orthography = models.ForeignKey(Orthography)
    frequency = models.FloatField(blank=True,null=True)

class PronouncedAs(models.Model):
    word_form = models.ForeignKey('WordForm')
    transcription = models.ForeignKey(Transcription)

class WordForm(models.Model):
    lemma = models.ForeignKey('Lemma')
    orthographies = models.ManyToManyField(Orthography,through = 'SpelledAs')
    transcriptions = models.ManyToManyField(Transcription,through = 'PronouncedAs')
    frequency = models.FloatField(blank=True,null=True)

    def get_transcriptions(self):
        return ".".join(str(t) for t in self.transcriptions.all())

    def get_spellings(self):
        return ", ".join(str(s) for s in self.orthographies.all())

    def __unicode__(self):
        return u'%s' % self.lemma.label

class Lemma(models.Model):
    label = models.CharField(max_length=250)
    category = models.ForeignKey(SyntacticCategory)
    frequency = models.FloatField(blank=True,null=True)

    #objects = WordManager()
    def __unicode__(self):
        return self.label

    def get_transcriptions(self):
        return ".".join(str(t) for wf in WordForm.objects.filter(lemma=self) for t in wf.transcriptions.all())

    def get_spelling_set(self):
        return {str(s) for wf in WordForm.objects.filter(lemma=self) for s in wf.orthographies.all()}

    def get_spellings(self):
        return ", ".join(self.get_spelling_set())

    #def getPrimaryCategory(self):
    #    if self.PrimaryCategory is not None:
    #        return self.PrimaryCategory
    #    self.PrimaryCategory = self.catrelationship_set.all()[0].Category.Label
    #    self.save()
    #    return self.PrimaryCategory
