
import os
from distutils.core import setup

class chdir(object):
    r""" Temporary directory change. """

    absdir = os.path.dirname(__file__)

    def __init__(self, dest_dir='.'):
        super(chdir, self).__init__()
        if not os.path.isabs(dest_dir):
            dest_dir = os.path.join(chdir.absdir, dest_dir)
        self.dest_dir = os.path.normpath(dest_dir)

    def __enter__(self):
        self.prev_dir = os.getcwd()
        os.chdir(self.dest_dir)

    def __exit__(self, *args):
        os.chdir(self.prev_dir)

def readfile(fname, default=None):
    if not os.path.exists(fname):
        return default

    with open(fname) as fp:
        return fp.read()

def readme(default):
    return readfile('README.md', default)

description = 'Simple Django utility library including a Jinja2 connection'

with chdir():
    setup(
        name='django-chang',
        version='0.1.0',
        description=description,
        long_description=readme(default=description),
        author='Niklas Rosenstein',
        author_email='rosensteinniklas@gmail.com',
        url='https://github.com/NiklasRosenstein/django-chang',
        download_url='https://github.com/NiklasRosenstein/django-chang',
        packages=['chang'],
        license="MIT",
        platforms=['Any'],
        classifiers=[
          'Development Status :: 5 - Production/Stable',
        ],
    )

