from django.conf import settings  # pragma: no cover
from django.test.simple import DjangoTestSuiteRunner  # pragma: no cover

try:  # pragma: no cover
    from xmlrunner import XMLTestRunner as runner
except:  # pragma: no cover
    runner = False


class TestSuiteRunner(DjangoTestSuiteRunner):  # pragma: no cover
    use_runner = runner

    def run_suite(self, suite, **kwargs):
        if self.use_runner and not self.failfast:
            return self.use_runner(
                output=getattr(settings, 'JUNIT_OUTPUT_DIR', '.')
            ).run(suite)
        else:
            return super(TestSuiteRunner, self).run_suite(suite, **kwargs)

    def setup_databases(self, *args, **kwargs):
        # no need for a database...
        pass
    teardown_databases = setup_databases
