from django.db import models
from cms.models import Page
from django.utils.translation import ugettext_lazy as _
from filer.fields.image import FilerImageField
from tinymce.models import HTMLField
from cms.models.pluginmodel import CMSPlugin


class Teaser(models.Model):
    page = models.OneToOneField(Page, null=False, blank=False, on_delete=models.CASCADE, related_name="page_teaser")
    preview_image = FilerImageField(verbose_name=_('preview image'), null=True,
                                    blank=True, on_delete=models.SET_NULL)
    teaser = HTMLField(blank=True)

    def __unicode__(self):
        return self.page.get_menu_title()

    class Meta:
        verbose_name = _('teaser')
        verbose_name_plural = _('teasers')


class Teasers(CMSPlugin):
    teasers = models.ManyToManyField(Teaser, db_table="cmsplugin_teasers_teasers", blank=True)

    def copy_relations(self, oldinstance):
        self.teasers = oldinstance.teasers.all()