# -*- coding: utf-8 -*-
from django.contrib import admin
from django.contrib.auth.admin import UserAdmin as OriginalUserAdmin
from django.contrib.auth.models import User as OriginalUser
from cms.utils.compat.dj import get_user_model


if getattr(OriginalUser._meta, 'swapped', False):
    class UserAdmin(OriginalUserAdmin):
        list_display = ('username', 'email', 'get_full_name', 'is_staff')
        search_fields = ('username', 'email',)

    admin.site.register(get_user_model(), UserAdmin)
