# -*- coding: utf-8 -*-
from django import forms

from cmskit.contact.nospam.forms import HoneyPotForm, RecaptchaForm, AkismetForm


class ContactForm(forms.Form):
    email = forms.EmailField()
    subject = forms.CharField(required=False)
    content = forms.CharField(widget=forms.Textarea())

  
class HoneyPotContactForm(HoneyPotForm):
    pass


class AkismetContactForm(AkismetForm):
    akismet_fields = {
        'comment_author_email': 'email',
        'comment_content': 'content'
    }
    akismet_api_key = None
    

class RecaptchaContactForm(RecaptchaForm):
    recaptcha_public_key = None
    recaptcha_private_key = None
    recaptcha_theme = None