# django-collectd-rest

[![Build Status](https://travis-ci.org/matwey/django-collectd-rest.svg?branch=master)](https://travis-ci.org/matwey/django-collectd-rest)

django-collectd-rest is a simple [Django] application to demonstrate RRD plots generated by [collectd] or any other [rrd] data. The application is built on top of [django-rest-framework] and provides REST API to access the plots.

There are two major things in django-collectd-rest, *graphs* are grouped into * groups*. Both the graphs and the groups are accessible through REST API. Using mutable access (POST, PUT, DELETE), you can configure you hierarchy, create new graphs or alter existing ones. You also can grab meta-info or ready PNG images by means of GET requests. Genuine ```rrdtool``` is currently used to render the plots.

## Installation

The following prerequisites are required to operate django-collectd-rest:
* [django-rest-framework] - powerful and flexible toolkit that makes it easy to build Web APIs.
* [rrd] - high performance data logging and graphing system for time series data.

To use django-collectd-rest in your django project, include the following code into your ```settings.py```:
```
INSTALLED_APPS = (
     #...
    'rest_framework',
    'collectd_rest',
)
```

Into your ```urls.py``` you have to add the following:
```
urlpatterns = patterns('',
    #...
    url(r'^collectd_rest/', include('collectd_rest.urls')),
)
```

## Configuration
The whole configuration are stored into the project database, there is not separate dedicated configfile. New graphs and groups are added by creating new objects. The latter can be done in different ways.

Using django database console:
```
from collectd_rest import models
group = models.GraphGroup(title="The Group", name="group1")
group.save()
graph = models.Graph(title="The Graph", name="graph1", priority=0, command="DEF:cpuuser=/path/to/rrd/cpu-0/cpu-idle.rrd:value:AVERAGE LINE2:cpuuser#000000:legend", group=group)
graph.save()
```

The ```GraphGroup``` model have two parameters: human-readable ```title``` and lookup field ```name``` to access the group by url like ```http://example.com/collectd_rest/group/{name}/```.
The ```Graph``` model have way more fields, including ```priority``` to sort the graphs inside one group, mandatory parent ```group```, and ```command``` to generate rrd plot.

The other ways to configure the application are Django fixtures, Django admin interface, [django-rest-framework] web browsable interface, and REST API itself. You can also modify the graphs hierarchy dynamically by means of custom REST client.

## Authentication and permissions
You may utilize all possible options provided by [django-rest-framework]. See [Tutorial](http://www.django-rest-framework.org/tutorial/4-authentication-and-permissions/) for reference.

## Caching
You may utilize all caching mechanisms provided by [Django] framework. See [Django's cache framework](https://docs.djangoproject.com/en/dev/topics/cache/).

## Using
To demonstrate how the framework can be used, let's look at the following JavaScript code ([jQuery] is used here). The following code renders the group names ```mygroup``` into corresponding ```div``` element, and the ```myothergroup``` into the other one.
```
<html>
<head>
<script type="text/javascript" src="http://yastatic.net/jquery/2.1.1/jquery.js"></script>
<script>
function renderGraph(graph) {
        var name  = graph['name'];
        var title = graph['title'];
        var url   = graph['url'];
        
        var code = "<div id=\"" + name + "\" class=\"django-collectd-rest-graph\">\n";
        code += "<div>" + title + "</div>\n";
        code += "<img src=" + url + " />\n";
        code += "</div>\n";
        return code;
};
function renderGroup(group) {
        var name  = group['name'];
        var title = group['title'];
        var graphs= group['graphs'];
        
        var code = "<div>" + title + "</div><ul>\n";
        graphs.forEach(function(g){
                code += "<li>" + renderGraph(g) + "</li>\n";
        });
        code += "</ul>\n";
        return code;
}

$(document).ready(function(){

        $.get( "http://example.com/collectd_rest/groups/", function( data ) {
                data.forEach(function(entry) {
                        var name = entry['name'];
                        var code = renderGroup(entry);
                        $(".django-collectd-rest-group#" + name).html(code);
                });
        });

});
</script>
</head>
<body>
<div id="test">
</div>
<div class="django-collectd-rest-group" id="mygroup"></div>
<div class="django-collectd-rest-group" id="myothergroup"></div>
</body>
</html>
```

## Feedback
If you have any questions, issues, or pull-requests, you are welcome to use GitHub infrastructure for them.

## License

Copyright (c) 2014, Matwey V. Kornilov

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


[Django]:https://www.djangoproject.com/
[collectd]:https://collectd.org/
[rrd]:http://oss.oetiker.ch/rrdtool/
[django-rest-framework]:http://www.django-rest-framework.org
[jQuery]:http://jquery.com/

