from django import forms
from django.utils.translation import ugettext_lazy as _


class BaseContactForm(forms.Form):
    name = forms.CharField(label=_('Name'), max_length=50)
    email = forms.EmailField(label=_('E-mail'), max_length=100)
    message = forms.CharField(
        label=_('Message'),
        max_length=6000,
        widget=forms.Textarea()
    )

class ContactForm(BaseContactForm):
    phone_number = forms.CharField(
        label=_('Phone number'),
        required=False,
    )
