from django import forms
from django.utils.translation import ugettext_lazy as _

from contato.widgets import AntiSpamInput


class BaseContactForm(forms.Form):
    name = forms.CharField(label=_('Name'), max_length=50)
    email = forms.EmailField(label=_('E-mail'), max_length=100)
    message = forms.CharField(
        label=_('Message'),
        max_length=6000,
        widget=forms.Textarea()
    )


class ContactForm(BaseContactForm):
    pass


class AntiSpamContactForm(ContactForm):
    # fake email input to prevent spam
    email_ = forms.CharField(required=False, widget=AntiSpamInput)

    def clean_email_(self):
        data = self.cleaned_data.get('email_')
        if data:
            msg = _("Field to detect spam bots. Don't provide any data here.")
            raise forms.ValidationError(msg)
        return data
