from django import forms
from django.utils.safestring import mark_safe


class AntiSpamInput(forms.TextInput):

    def render(self, name, value, attrs=None):
        html = '<style type="text/css" scoped>#id_email_ {display:none;}</style>'
        html += super(AntiSpamInput, self).render(name, value, attrs)
        return mark_safe(html)
