from django.conf import settings
from django.utils import unittest
from django.test.client import RequestFactory
from django.utils.importlib import import_module

from cookieless.utils import CryptSession


class CryptTestCase(unittest.TestCase):
    """
    Check the session id encryption is working OK
    """
    # urls = 'django-cookieless.test_urls'
    
    def setUp(self):
        """ Get a session and a crypt_session """
        self.engine = import_module(settings.SESSION_ENGINE)
        self.crypt_sesh = CryptSession()
        self.factory = RequestFactory()
        
    def crypt_ok(self, request=None):
        """ Check encryption works with various settings """
        if not request:
            request = self.factory.get('/')
        session = self.engine.SessionStore()
        session.create()
        self.assertNotEqual(session.session_key, None)
        sessionid = self.crypt_sesh.encrypt(request, session.session_key)
        session_key = self.crypt_sesh.decrypt(request, sessionid)
        return session.session_key, session_key

    def test_default(self):
        settings.COOKIELESS_CLIENT_ID = False
        settings.COOKIELESS_HOSTS = []
        keys = self.crypt_ok()
        self.assertEqual(*keys)

    def test_client_id(self):
        settings.COOKIELESS_CLIENT_ID = True
        settings.COOKIELESS_HOSTS = []
        keys = self.crypt_ok()
        self.assertEqual(*keys)

    def test_hosts_check(self):
        settings.COOKIELESS_CLIENT_ID = False
        request = self.factory.get('/')
        request.META['HTTP_REFERER'] = 'http://localhost:12345/foobar'
        settings.COOKIELESS_HOSTS = ['localhost', ]
        keys = self.crypt_ok(request)
        self.assertEqual(*keys)


