"""
Copyright 2009 55 Minutes (http://www.55minutes.com)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

from html_module_exceptions import html_module_exceptions
from templates import default_module_errors as module_errors

def html_module_errors(filename, errors):
    """
    Creates an index page of packages and modules which had problems being imported
    for coverage analysis at the specified filename.

    It uses `templates.default_module_errors` to create the page. The template
    contains the following sections which need to be rendered and assembled into
    the final HTML.

    TOP: Contains the HTML declaration and head information, as well as the
         inline stylesheet.

    CONTENT_HEADER: The header portion of the body.

    CONTENT_BODY: A list of excluded packages and modules. Requires the following
                  variable:
                  * ``%(long_desc)s`` A long description of what this page
                    is about.
                  * ``%(exception_list)s`` List of package and module names
                    which is generated by looping through each line and
                    concatenanting together rendered ``EXCEPTION_LINE``
                    template (see below).

    BOTTOM: Just a closing ``</body></html>``

    EXCEPTION_LINE: Used to assemble the content of ``%(exception_list)s`` for ``CONTENT_BODY``.
                    Requires the following variable:
                    * ``%(module_name)s``
    """
    long_desc = """\
    <code>django_coverage.utils.module_tools.find_or_load_module</code> had
    problems importing these packages and modules:
    """
    html_module_exceptions(filename, errors, module_errors, long_desc)
