"""
Copyright 2009 55 Minutes (http://www.55minutes.com)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Changed by Mikhail Korobov.
"""

from html_module_exceptions import html_module_exceptions
from templates import default_module_excludes as module_excludes

def html_module_excludes(filename, excludes):
    """
    Creates an index page of packages and modules which were excluded from the
    coverage analysis at the specified filename.

    It uses `templates.default_module_excludes` to create the page. The template
    contains the following sections which need to be rendered and assembled into
    the final HTML.

    TOP: Contains the HTML declaration and head information, as well as the
         inline stylesheet.

    CONTENT_HEADER: The header portion of the body.

    CONTENT_BODY: A list of excluded packages and modules. Requires the following
                  variable:
                  * ``%(long_desc)s`` A long description of what this page
                    is about.
                  * ``%(exception_list)s`` List of package and module names
                    which is generated by looping through each line and
                    concatenanting together rendered ``EXCEPTION_LINE``
                    template (see below).

    BOTTOM: Just a closing ``</body></html>``

    EXCEPTION_LINE: Used to assemble the content of ``%(exclude_list)s`` for ``CONTENT_BODY``.
                    Requires the following variable:
                    * ``%(module_name)s``
    """
    long_desc = """\
    These packages and modules were excluded from the coverage analysis in
    <code>django.conf.settings.COVERAGE_MODULE_EXCLUDES</code> or they do
    not contain any executable statements:
    """
    html_module_exceptions(filename, excludes, module_excludes, long_desc)

