# -*- coding: utf-8 -*-
#
#  Copyright (c) 2008-2012 Guilherme Gondim and contributors
#
#  This file is part of Django Diário.
#
#  Django Diário is free software under terms of the GNU Lesser
#  General Public License version 3 (LGPLv3) as published by the Free
#  Software Foundation. See the file README for copying conditions.
#

from diario.models import Entry
from django.views.generic.list import ListView
from django.views.generic import dates
from diario.settings import DIARIO_NUM_LATEST


class EntryDetail(dates.DateDetailView):
    slug_field = 'slug'
    date_field = 'pub_date'
    queryset = Entry.published_on_site.all()
    month_format = '%m'

    def dispatch(self, request, *args, **kwargs):
        if request.user.has_perm('diario.change_entry'):
            self.allow_future = True
            self.queryset = Entry.on_site.all()
        else:
            self.allow_future = False
        return super(EntryDetail, self).dispatch(request, *args, **kwargs)


class EntryArchiveYear(dates.YearArchiveView):
    queryset = Entry.published_on_site.all()
    date_field = 'pub_date'


class EntryArchiveMonth(dates.MonthArchiveView):
    month_format = '%m'
    date_field = 'pub_date'
    queryset = Entry.published_on_site.all()


class EntryArchiveDay(dates.DayArchiveView):
    month_format = '%m'
    date_field = 'pub_date'
    queryset = Entry.published_on_site.all()


class EntryList(ListView):
    queryset = Entry.published_on_site.all()
    paginate_by = DIARIO_NUM_LATEST
