import datetime
from haystack import indexes
from dictionary_search.models import SearchEntry


class SearchEntryIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    entry = indexes.CharField(model_attr='entry_normalized', boost=100)
    content_auto = indexes.EdgeNgramField(model_attr='entry_normalized')
    chronology = indexes.CharField(model_attr='chronology')
    word_class = indexes.CharField(model_attr='word_class')
    language = indexes.CharField(model_attr='language')
    priority_level_1 = indexes.CharField(model_attr='priority_level_1')
    priority_level_2 = indexes.CharField(model_attr='priority_level_2')
    priority_level_3 = indexes.CharField(model_attr='priority_level_3')
    priority_level_4 = indexes.CharField(model_attr='priority_level_4')

    snippet_text = indexes.CharField(model_attr='snippet_text')

    def get_model(self):
        return SearchEntry

    def index_queryset(self, using=None):
        """Used when the entire index for model is updated."""
        return self.get_model().objects.all()
