
from django.conf.urls import patterns, include, url

from django.views.generic import ListView, DetailView
from django.conf import settings

from haystack.forms import ModelSearchForm
from haystack.query import SearchQuerySet

from views import XMLResponseSearchView, autocomplete, dictionary_upload
from views import most_popular, random_json
from models import SearchEntry
from forms import DictionarySearchForm


sqs = SearchQuerySet()


urlpatterns = patterns(
    'haystack.views',
    url(r'full/$', XMLResponseSearchView(
        template='search/api_search.html',
        searchqueryset=sqs,
        form_class=DictionarySearchForm,
    ), name='api_search'),
    url(r'snippet/$', XMLResponseSearchView(
        template='search/api_snippet_search.html',
        searchqueryset=sqs,
        form_class=DictionarySearchForm,
    ), name='snippet_search'),
    url(r'random/$', ListView.as_view(
        queryset=SearchEntry.objects.order_by('?')[:settings.RESULTS_PER_PAGE],
        context_object_name='searchentry_list',
        content_type='text/xml'
    ), name='random'),
    url(r'random/json/$', random_json, name='random_json'),
    url(r'popular/$', most_popular, name='most_popular'),
    url(r'autocomplete/$', autocomplete, name='autocomplete'),
    url(r'upload_xml/$', dictionary_upload, name='dictionary_upload'),
    url(r'lookup/(?P<pk>[^/]+)/$', DetailView.as_view(
        model=SearchEntry,
        context_object_name='search_entry',
        content_type='text/xml')
    )

)
