from datetime import datetime

from django import forms
from django.conf import settings

from haystack.query import SearchQuerySet
from haystack.forms import ModelSearchForm


class DictionarySearchForm(ModelSearchForm):
    sqs = None

    def search(self):
        sqs = SearchQuerySet()

        if not self.is_valid():
            return self.no_query_found()

        # Get query and filter those that starts with it

        query = self.cleaned_data['q']

        # Use exact search if query is inside quotes.
        if len(query) > 1 and query[0] == '"' and query[len(query) - 1] == '"':
            query = query[1:len(query) - 1]
            print query
            sqs = (sqs.filter(entry=query) |
                   sqs.filter(text=query))

        else:
            sqs = (sqs.filter(entry__exact=query) |
                   sqs.filter(entry__startswith=query) |
                   sqs.filter(text__startswith=query))

        self.sqs = sqs

        return sqs


class DictionaryUploadForm(forms.Form):
    """This is the form used to upload a new database for indexing."""
    xml_file = forms.FileField()
    upload_password = forms.CharField(widget=forms.PasswordInput())
