from django.db import models


class SearchEntry(models.Model):
    """A single entry to be searched & returned by the search API."""
    entry = models.CharField(max_length=255)    # Dictionary entry.
                                                # Note: This is NOT unique.
    entry_normalized = models.CharField(max_length=255)

    chronology = models.CharField(max_length=10)          # For the time being,
                                                          # only the year.
    word_class = models.CharField(max_length=255)
    language = models.CharField(max_length=255, blank=True)
    """
    The priority fields are used for doing weighted search.
    Search terms are boosted according to their priority level.

    Priority levels are specified in the setup for the data import procedure.
    """
    priority_level_1 = models.CharField(max_length=4096)
    priority_level_2 = models.CharField(max_length=4096, blank=True)
    priority_level_3 = models.CharField(max_length=4096, blank=True)
    priority_level_4 = models.CharField(max_length=4096, blank=True)
    priority_level_5 = models.CharField(max_length=4096, blank=True)
    priority_level_6 = models.CharField(max_length=4096, blank=True)

    snippet_text = models.CharField(max_length=1024)
    snippet_link = models.CharField(max_length=255)

    """"The HTML to be returned to display on the web page.

    The final form of this HTML is generated as part of the data import.
    Client-side web designers must use style sheets if they want to customize
    the layout; or else, the data transformation during import must be changed.
    In any case, the presentation or specific HTML formatting is not handled by
    this API."""
    html = models.TextField()

    def __unicode__(self):
        return self.entry


class VisitDetails(models.Model):
    """A record in the search log."""
    query = models.CharField(max_length=256)
    time = models.DateTimeField(auto_now_add=True, blank=True)
    user_agent = models.CharField(max_length=4096)
    remote_ip = models.CharField(max_length=128)
    calling_url = models.CharField(max_length=4096)
    referer = models.CharField(max_length=4096)
    count = models.IntegerField(default=0)

    def __unicode__(self):
        return "{0}|{1}|{2}|{3}|{4}|{5}|{6}".format(
            self.query, self.time, self.user_agent, self.remote_ip,
            self.calling_url, self.referer, self.count
        )
