"""Django DND autentication"""

from django.conf import settings

__all__ = []

_DEFAULTS = {
    'CAS_SERVER_URL': 'https://login.dartmouth.edu/cas/',
    'DND_DB_TABLE': 'dartmouth_dnd',
    'DND_SERVER': 'dnd.dartmouth.edu',
}

for key, value in _DEFAULTS.iteritems():
    try:
        getattr(settings, key)
    except AttributeError:
        setattr(settings, key, value)
    # Suppress errors from DJANGO_SETTINGS_MODULE not being set
    except ImportError:
        pass
