from dockitcms.scope import get_site_scope, Scope, ScopeList

class DefaultScopeMiddleware(object):
    def process_template_response(self, request, response):
        if hasattr(response, 'context_data') and response.context_data is not None: #TODO this shouldn't happen
            context = response.context_data
            if 'scopes' not in context:
                context['scopes'] = ScopeList([get_site_scope()])
                if 'object' in context and not any([scope.name == 'object' for scope in context['scopes']]):
                    context['scopes'].append(Scope(name='object', object=context['object']))
        return response

