# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _

try:
    from caching.base import CachingMixin
except ImportError:
    class CachingMixin(object):
        pass

    class CachingManager(models.Manager):

        def get_query_set(self):
            return CachingQuerySet(self.model, using=self._db)

        def no_cache(self):
            return self


    class CachingQuerySet(models.query.QuerySet):

        def no_cache(self):
            return self


class Watermark(CachingMixin, models.Model):

    name = models.CharField(max_length=50, verbose_name=_("name"))
    image = models.ImageField(upload_to='watermarks', verbose_name=_("image"))
    is_active = models.BooleanField(default=True, blank=True, verbose_name=_("is active"))

    # for internal use...

    date_created = models.DateTimeField(auto_now_add=True)
    date_updated = models.DateTimeField(auto_now=True)

    objects = CachingManager()

    class Meta:
        ordering = ['name']
        verbose_name = _("watermark")
        verbose_name_plural = _("watermarks")

    def __unicode__(self):
        return self.name
