from django.core.urlresolvers import reverse
from django.conf import settings
from django.utils.translation import ugettext_lazy as _


def add_item(request, title, viewname=None, **kwargs):
    """
    Attempts to add a breadcrumbs item to the request using the 'breadcrumbs' app.
    """
    if not hasattr(request, '_breadcrumbs'):
        setattr(request, '_breadcrumbs', [])
    item = {
        'title': title
    }
    if viewname:
        item['url'] = reverse(viewname, **kwargs)
    request._breadcrumbs.append(item)


def get_breadcrumbs(request):
    """
    Returns breadcrumbs on the request if it exists, otherwise returns
    an empty list.
    """
    home_url = getattr(settings, 'BREADCRUMBS_HOME_URL', None)
    home_title = getattr(settings, 'BREADCRUMBS_HOME_TITLE', _('Home'))
    breadcrumbs = getattr(request, '_breadcrumbs', [])
    if breadcrumbs and home_url:
        breadcrumbs.insert(0, {
            'title': home_title,
            'url': reverse(home_url)
        })
    size = len(breadcrumbs)
    for i, b in enumerate(breadcrumbs, start=1):
        if i == size and 'url' in b:
            del b['url']
    return breadcrumbs