#!/usr/bin/env python
# coding: utf-8
#
# Copyright (c) 2008—2014 Anton Ruhlov and contributors
#
#  This file is part of django-easybreadcrumbs.
#
#  django-breadcrumbs is free software under terms of the GNU Lesser
#  General Public License version 3 (LGPLv3) as published by the Free
#  Software Foundation. See the file README for copying conditions.
#

import os
from setuptools import setup


setup(
    name='django-easybreadcrumbs',
    version='0.1',
    packages=['breadcrumbs'],

    requires=['python (>= 2.5)', 'django (>= 1.0)'],
    # in case you want to use slugify() with support for transliteration:
    extras_require={

    },
    description='Django easy breadcrumbs.',
    author='Anton Ruhlov',
    author_email='antonruhlov@gmail.com',
    url='https://github.com/aruhlov/django-easybreadcrumbs/',
    download_url='https://github.com/aruhlov/django-easybreadcrumbs/archive/0.1.zip',
    include_package_data=True,
    license='GNU Lesser General Public License (LGPL), Version 3',
    keywords='django breadcrumbs',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Text Processing :: General',
    ],
)