from django.db import models

from cms.models.pluginmodel import CMSPlugin
from django.utils.translation import ugettext_lazy as _
from realestate_maps.models import HousesOverview as HousesOverviewModel


class HousesOverview(CMSPlugin):
    overview = models.ForeignKey(HousesOverviewModel)
    use_autoscale = models.BooleanField(_("use automatic scaling"), default=True,
                                        help_text=_('tries to auto scale the image based on the placeholder context'))
    width = models.PositiveIntegerField(_("width"), null=True, blank=True)
    height = models.PositiveIntegerField(_("height"), null=True, blank=True)