from django.contrib import admin
from models import *
from models import PlaceType, HouseField
from cms.admin.pageadmin import PageAdmin
from cms.models.pagemodel import Page
from realestate.models import Group
from realestate.admin import GroupAdmin


class RealestateInline(admin.StackedInline):
    model = Realestate
    can_delete = False
    filter_vertical = ['house_kinds', 'fases']

PageAdmin.inlines.append(RealestateInline)
try:
    admin.site.unregister(Page)
except:
    pass
admin.site.register(Page, PageAdmin)


class GroupPageInline(admin.StackedInline):
    model = CMSGroupPage
    can_delete = False
    fk_name = 'group'


class GroupPageAdmin(admin.ModelAdmin):
    list_display = ['page', 'website', 'group']


GroupAdmin.inlines.append(GroupPageInline)
try:
    admin.site.unregister(Group)
except:
    pass
admin.site.register(Group, GroupAdmin)

admin.site.register(CMSGroupPage, GroupPageAdmin)
admin.site.register(PlaceType)
admin.site.register(HouseField)