from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from models import *
from django.utils.translation import ugettext_lazy as _
from realestate.models import House


class GroupPlugin(CMSPluginBase):
    """Abstract plugin which obtains the project from the page object"""
    def render(self, context, instance, placeholder):
        context = super(GroupPlugin, self).render(context, instance, placeholder)
        page2 = instance.placeholder.page
        extended_fields = None
        try:
            extended_fields = page2.group_fields
        except:
            try:
                extended_fields = page2.publisher_draft.group_fields
            except:
                pass

        context.update({
            'group': extended_fields.group,
        })

        return context


class HousesPlugin(CMSPluginBase):
    """Plugin which obtains a list of houses from the page and renders the fields specified"""
    name = _("Houses")
    render_template = "realestate/plugins/houses.html"
    model = Houses

    def render(self, context, instance, placeholder):
        context = super(HousesPlugin, self).render(context, instance, placeholder)
        page2 = instance.placeholder.page
        extended_fields = None
        houses = None
        try:
            extended_fields = page2.group_fields
        except:
            try:
                extended_fields = page2.publisher_draft.group_fields
            except:
                pass

        if extended_fields:
            houses = House.objects

            project = extended_fields.group
            if project:
                houses = houses.filter(parent=project)
            subgroup = extended_fields.subgroup
            if subgroup:
                houses = houses.filter(subgroup=subgroup)
            house_kinds = extended_fields.house_kinds.all()
            if house_kinds:
                houses = houses.filter(house_type__house_kinds__in=house_kinds)
            fases = extended_fields.fases.all()
            if fases:
                houses = houses.filter(fase__in=fases)

        context.update({
            'houses': houses,
            'fields': instance.fields.values_list('name', flat=True)
        })
        return context

plugin_pool.register_plugin(HousesPlugin)


class PlacesPlugin(GroupPlugin):
    name = _("Nearby places")
    render_template = "realestate/plugins/places.html"
    model = Places
    filter_vertical = ['types']


plugin_pool.register_plugin(PlacesPlugin)