from django.db import models
from cms.models import Page
from realestate.models import Group, HouseKind, Fase, SubGroup
from django.utils.translation import ugettext_lazy as _
from filer.fields.image import FilerImageField
from tinymce.models import HTMLField
from cms.models.pluginmodel import CMSPlugin


class Realestate(models.Model):
    page = models.OneToOneField(Page, null=False, blank=False, on_delete=models.CASCADE, related_name='group_fields')
    group = models.ForeignKey(Group, verbose_name=_('project'), null=True, blank=True, on_delete=models.CASCADE,
                              related_name='realestate_group')
    subgroup = models.ForeignKey(SubGroup, verbose_name=_('house type'), null=True, blank=True,
                                 on_delete=models.CASCADE)
    house_kinds = models.ManyToManyField(HouseKind, blank=True)
    fases = models.ManyToManyField(Fase, blank=True)

    def __unicode__(self):
        return self.page.get_menu_title()

    class Meta:
        verbose_name = _('Realestate page extension')
        verbose_name_plural = _('Realestate page extensions')


class CMSGroupPage(models.Model):
    page = models.OneToOneField(Page, null=True, blank=True, on_delete=models.CASCADE, related_name='extended_fields')
    website = models.CharField(_('website'), max_length=50, blank=True)
    group = models.OneToOneField(Group, verbose_name=_('project'), null=False, blank=False,
                                 on_delete=models.CASCADE)
    preview_image = FilerImageField(related_name="grouppage_preview_image", verbose_name=_('preview image'), null=True,
                                    blank=True, on_delete=models.SET_NULL)
    teaser2 = HTMLField(_('teaser'), blank=True)
    order = models.PositiveIntegerField(_('order'), null=True, blank=True)

    class Meta:
        verbose_name = _('group display')
        verbose_name_plural = _('group displays')
        ordering = ['order']

    def __unicode__(self):
        if self.page:
            return self.page.get_menu_title()
        if self.website:
            return self.website
        else:
            return ' '


class PlaceType(models.Model):
    name = models.CharField(max_length=50)

    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name = _('place type')
        verbose_name_plural = _('place types')
        db_table = "realestate_plugins_placetype"


class Places(CMSPlugin):
    types = models.ManyToManyField(PlaceType, db_table="cmsplugin_places_types", blank=True)

    def copy_relations(self, oldinstance):
        self.types = oldinstance.types.all()


class HouseField(models.Model):
    name = models.CharField(max_length=50)

    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name = _('house field')
        verbose_name_plural = _('house fields')


class Houses(CMSPlugin):
    fields = models.ManyToManyField(HouseField, db_table="cmsplugin_houses_fields", blank=True)

    def copy_relations(self, oldinstance):
        self.fields = oldinstance.fields.all()

