from django.contrib import admin
from models import *


class FaseInline(admin.TabularInline):
    model = Fase
    extra = 0


class HouseInline(admin.TabularInline):
    model = House
    extra = 0


class HouseTypeInline(admin.StackedInline):
    model = HouseType
    extra = 0


class SubGroupInline(admin.TabularInline):
    model = SubGroup
    extra = 0


class SpaceInline(admin.TabularInline):
    model = Space
    extra = 0


class HouseAdmin(admin.ModelAdmin):
    list_display = ('number', 'fase', 'parent', 'subgroup', 'house_type', 'garden', 'status')
    list_filter = ['fase', 'parent', 'subgroup', 'status', 'house_type']


class SubGroupAdmin(admin.ModelAdmin):
    list_display = ('name', 'group')

    inlines = [
        HouseTypeInline, HouseInline
    ]


class HouseTypeAdmin(admin.ModelAdmin):
    list_display = ('name', 'parent', 'subgroup', 'rooms', 'living_area', 'ground_area', 'bvo',
                    'outdoor_space', 'outdoor_storage', 'base_price')
    filter_vertical = ['house_kinds']
    list_filter = ['parent']


    inlines = [
        HouseInline, SpaceInline
    ]


class GroupAdmin(admin.ModelAdmin):
    list_display = ['name']

    inlines = [
        FaseInline, SubGroupInline
    ]

admin.site.register(SubGroup, SubGroupAdmin)
admin.site.register(Group, GroupAdmin)
admin.site.register(House, HouseAdmin)
admin.site.register(HouseType, HouseTypeAdmin)
admin.site.register(HouseKind, admin.ModelAdmin)