import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-estate',
    version='0.1.0',
    packages=['realestate'],
    include_package_data=True,
    license='No License',
    description='Package with models for new -and realestate. Base for many other estate packages.',
    long_description=README,
    url='http://www.de-nieuwbouwmakelaar.nl',
    author='Vincent van Bergen',
    author_email='v.vanbergen@gmail.com',
    install_requires=[
        "Django >= 1.5",
    ],
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License', # example license
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        # replace these appropriately if you are using Python 3
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
