from django.views import generic
from realestate.models import Group, House
from django.views.generic.detail import BaseDetailView
import json
from django.http import HttpResponse


class GroupListView(generic.ListView):
    model = Group


class GroupDetailView(generic.detail.DetailView):
    model = Group


class HouseDetailView(generic.detail.DetailView):
    model = House


class JSONResponseMixin(object):
    """
    A mixin that can be used to render a JSON response.
    """
    def render_to_json_response(self, context, **response_kwargs):
        """
        Returns a JSON response, transforming 'context' to make the payload.
        """
        return HttpResponse(
            self.convert_context_to_json(context),
            content_type='application/json',
            **response_kwargs
        )

    def convert_context_to_json(self, context):
        return json.dumps(context)


class HouseDetailJSON(JSONResponseMixin, BaseDetailView):
    model = House

    def get_context_data(self, **kwargs):
        #context = super(HouseDetailJSON, self).get_context_data(**kwargs)
        house_type = self.object.house_type
        context = {}
        context['number'] = self.object.number
        context['base_price'] = house_type.base_price
        context['status'] = self.object.get_status_display()
        context['living_area'] = house_type.living_area
        context['ground_area'] = house_type.ground_area
        #context['house_kinds'] = house_type.house_kinds.all()
        return context

    def render_to_response(self, context, **response_kwargs):
        return self.render_to_json_response(context, **response_kwargs)