django-explain-commands
=======================

Are you tired to find where each command coming from? django-explain-commands
helps you to find which Django application provides each command.

Installation
------------

 1. pip install django-explain-commands

 2. Add `explain_commands` to `INSTALLED_APPS`.

Usage
-----
 
Run `python manage.py explain_commands` and enjoy.

Sample output:

    $ python manage.py explain_commands
    django.contrib.auth =>
        changepassword -- Change a user's password for django.contrib.auth.
        createsuperuser -- Used to create a superuser.
    django.core =>
        cleanup -- Can be run as a cronjob or directly to clean ou...
        compilemessages -- Compiles .po files to .mo files for use with bu...
        createcachetable -- Creates the table needed to use the SQL cache b...
        dbshell -- Runs the command-line client for specified data...
        diffsettings -- Displays differences between the current settin...
        dumpdata -- Output the contents of the database as a fixtur...
        flush -- Executes ``sqlflush`` on the current database.
        inspectdb -- Introspects the database tables in the given da...
        loaddata -- Installs the named fixture(s) in the database.
        makemessages -- Runs over the entire source tree of the current...
        reset -- Executes ``sqlreset`` for the given app(s) in t...
        runfcgi -- Runs this project as a FastCGI application. Req...
        runserver -- Starts a lightweight Web server for development.
        shell -- Runs a Python interactive interpreter. Tries to...
        sql -- Prints the CREATE TABLE SQL statements for the ...
        sqlall -- Prints the CREATE TABLE, custom SQL and CREATE ...
        sqlclear -- Prints the DROP TABLE SQL statements for the gi...
        sqlcustom -- Prints the custom table modifying SQL statement...
        sqlflush -- Returns a list of the SQL statements required t...
        sqlindexes -- Prints the CREATE INDEX SQL statements for the ...
        sqlinitialdata -- RENAMED: see 'sqlcustom'
        sqlreset -- Prints the DROP TABLE SQL, then the CREATE TABL...
        sqlsequencereset -- Prints the SQL statements for resetting sequenc...
        startapp -- Creates a Django app directory structure for th...
        validate -- Validates all installed models.
    explain_commands =>
        explain_commands -- Explain where each command is coming from.
    south =>
        convert_to_south -- Quickly converts the named application to use S...
        datamigration -- Creates a new template data migration for the g...
        graphmigrations -- Outputs a GraphViz dot file of all migration de...
        migrate -- Runs migrations for all apps.
        schemamigration -- Creates a new template schema migration for the...
        startmigration -- Depereciated command
        syncdb -- Create the database tables for all apps in INST...
        test -- Runs the test suite for the specified applicati...
        testserver -- Runs a development server with data from the gi...

