# encoding: utf-8

from django.conf import settings
from django.conf.urls.defaults import url, patterns, include
from django.contrib import admin
from django.utils.functional import lazy
from django.utils.translation import ugettext as _

urlpatterns = patterns('',

    # Admin password reset
    url(r'^change/$', 'django.contrib.auth.views.password_change', {
        'template_name': 'admin/account/password_change.html',
        'post_change_redirect': '/admin/password/changed/'},
        name='admin_password_change'),
    url(r'^changed/$', 'django.contrib.auth.views.password_change_done', {
        'template_name': 'admin/account/password_change_done.html'},
        name='admin_password_changed'),
    url(r'^reset/$', 'django.contrib.auth.views.password_reset', {
        'template_name': 'admin/account/password_reset.html',
        'email_template_name': 'admin/account/password_reset_email.html'},
        name='admin_password_reset'),
    url(r'^reset/send/$', 'django.contrib.auth.views.password_reset_done', {
        'template_name': 'admin/account/password_reset_done.html'}),
    url(r'^reset/(?P<uidb36>[0-9A-Za-z]+)-(?P<token>.+)/$', 'django.contrib.auth.views.password_reset_confirm', {
        'template_name': 'admin/account/password_reset_confirm.html',
        'post_reset_redirect': '/admin/password/instellen/voltooid/'}),
    url(r'^reset/completed/$', 'django.contrib.auth.views.password_reset_complete', {
        'template_name': 'admin/account/password_reset_complete.html'}),

)
