import os
from setuptools import setup

with open(os.path.join(os.path.dirname(__file__), 'README.md')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-fine-uploader',
    version='0.0.1',
    packages=['django_fine_uploader'],
    include_package_data=True,
    description='A simple plug-n-play fine-uploader module',
    long_description=README,
    url='https://github.com/derek-adair/',
    author='Derek Adair',
    author_email='d@derekadair.com',
    license='MIT',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2.7',
    ],
    keywords='Django Fine Uploader fine-uploader',
    install_requires=['boto'],
    extras_require = {
        'dev': ['check-manifest'],
        'test': ['coverage'],
    },
)
