/*jslint unparam: true, browser: true, indent: 2 */
;(function ($, window, document, undefined) {
  'use strict';

  Foundation.libs.tab = {
    name : 'tab',

    version : '5.0.3',

    settings : {
      active_class: 'active',
      callback : function () {}
    },

    init : function (scope, method, options) {
      this.bindings(method, options);
    },

    events : function () {
      $(this.scope).off('.tab').on('click.fndtn.tab', '[data-tab] > dd > a', function (e) {
        e.preventDefault();

        var tab = $(this).parent(),
            tabs = tab.closest('[data-tab]'),
            target = $('#' + this.href.split('#')[1]),
            siblings = tab.siblings(),
            settings = tabs.data('tab-init');
        
        // allow usage of data-tab-content attribute instead of href
        if ($(this).data('tab-content')) {
          target = $('#' + $(this).data('tab-content').split('#')[1]);
        }
        
        tab.addClass(settings.active_class).trigger('opened');
        siblings.removeClass(settings.active_class);
        target.siblings().removeClass(settings.active_class).end().addClass(settings.active_class);
        settings.callback(tab);
        tabs.trigger('toggled', [tab]);
      });
    },

    off : function () {},

    reflow : function () {}
  };
}(jQuery, this, this.document));
