import sys
import time
import logging
import json

from watchdog.observers import Observer
from watchdog.events import FileSystemEventHandler
from bs4 import BeautifulSoup

from django.conf import settings


fresh = False


class RefreshEventHandler(FileSystemEventHandler):

    def on_any_event(self, event):
        global fresh
        fresh = True


class FreshMiddleware(object):

    def process_response(self, request, response):
        if not settings.DEBUG:
            return response

        mimetype = response._headers['content-type'][1]
        global fresh

        if mimetype == 'application/json':
            items = json.loads(response.content)
            if fresh and items.get('fresh') != None:
                fresh = False
                items['fresh'] = True
                response.content = json.dumps(items)
        elif mimetype == 'text/html; charset=utf-8':
            soup = BeautifulSoup(response.content)
            script_fresh = soup.new_tag('script', src='/static/fresh/js/refresher.js')
            soup.head.append(script_fresh)
            response.content = soup.prettify()

        return response

    def watcher(self):
        observer = Observer()

        path = settings.SITE_ROOT
        event_handler = RefreshEventHandler()
        observer.schedule(event_handler, path, recursive=True)

        observer.start()

    def __init__(self):
        if settings.DEBUG:
            self.watcher()

