#!/usr/bin/env python
# coding: utf-8

from setuptools import setup, find_packages
import os

version = __import__('generic_helpers').get_version()
readme = os.path.join(os.path.dirname(__file__), 'README.rst')

CLASSIFIERS = [
    'Development Status :: 4 - Beta',
    'Environment :: Web Environment',
    'Intended Audience :: Developers',
    'License :: OSI Approved :: BSD License',
    'Operating System :: OS Independent',
    'Programming Language :: Python',
    'Framework :: Django'
]

setup(
    name='django-generic-helpers',
    author='Mikhail Porokhovnichenko <marazmiki@gmail.com>',
    version=version,
    author_email='marazmiki@gmail.com',
    url='http://pypi.python.org/pypi/django-generic-helpers',
    download_url='http://bitbucket.org/marazmiki/django-generic-helpers/get/tip.zip',
    description='The small frameworks that helps to write reusable django apps',
    long_description=open(readme).read(),
    license='MIT license',
    platforms=['OS Independent'],
    classifiers=CLASSIFIERS,
    install_requires=[
        'Django>=1.3.1',
    ],
    packages=find_packages(),
    include_package_data=True,
    zip_safe=False)
