
from south.db import db
from django.db import models
from github.models import *

class Migration:
    
    def forwards(self, orm):
        
        # Deleting unique_together for [slug] on project.
        db.delete_unique('github_project', ['slug'])
        
        # Changing field 'User.name'
        # (to signature: django.db.models.fields.CharField(max_length=100, blank=True))
        db.alter_column('github_user', 'name', orm['github.user:name'])
        
        # Creating unique_together for [user, slug] on Project.
        db.create_unique('github_project', ['user_id', 'slug'])
        
    
    
    def backwards(self, orm):
        
        # Deleting unique_together for [user, slug] on Project.
        db.delete_unique('github_project', ['user_id', 'slug'])
        
        # Changing field 'User.name'
        # (to signature: django.db.models.fields.CharField(max_length=100))
        db.alter_column('github_user', 'name', orm['github.user:name'])
        
        # Creating unique_together for [slug] on project.
        db.create_unique('github_project', ['slug'])
        
    
    
    models = {
        'github.blob': {
            'commit': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'blobs'", 'to': "orm['github.Commit']"}),
            'data': ('django.db.models.fields.TextField', [], {}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'mime_type': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'path': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'sha': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'size': ('django.db.models.fields.IntegerField', [], {'default': '0'})
        },
        'github.commit': {
            'created': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'message': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'project': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'commits'", 'to': "orm['github.Project']"}),
            'sha': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'tree': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'})
        },
        'github.project': {
            'Meta': {'unique_together': "(('user', 'slug'),)"},
            'created': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {}),
            'github_repo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'slug': ('django.db.models.fields.SlugField', [], {'db_index': 'True', 'max_length': '50', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['github.User']", 'null': 'True'})
        },
        'github.user': {
            'blog': ('django.db.models.fields.URLField', [], {'max_length': '200', 'blank': 'True'}),
            'company': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'followers_count': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'following_count': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'location': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'blank': 'True'}),
            'public_gist_count': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'}),
            'public_repo_count': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'})
        }
    }
    
    complete_apps = ['github']
