#!/usr/bin/env python
from setuptools import setup

with open('README.rst') as file:
    long_description = file.read()

setup(
    name='django-gravatar-tags',
    version='1.0.0',
    description='Easy to use Gravatar template tags for Django',
    long_description=long_description,
    author='Marcus Fredriksson',
    author_email='drmegahertz@gmail.com',
    url='http://github.com/DrMegahertz/django-gravatar-tags',
    packages=[
        'django_gravatar_tags',
        'django_gravatar_tags.templatetags',
    ],
    package_dir={'': 'src'},
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Plugins',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: Implementation :: CPython',
        'Topic :: Internet :: WWW/HTTP',
    ]
)
